/*
 * Decompiled with CFR 0.152.
 */
package com.example.spendcm;

import com.example.spendcm.command.SPENDCMCommand;
import com.example.spendcm.config.ModConfig;
import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SPENDCM
implements ModInitializer {
    public static final String MOD_ID = "spendcm";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"spendcm");
    private static final Map<UUID, Long> playerLastActivity = new HashMap<UUID, Long>();
    private static MinecraftServer server;
    private static long lastCheckTime;
    private static ModConfig config;

    public void onInitialize() {
        config = ModConfig.load();
        LOGGER.info("SPENDCM \u6a21\u7ec4\u5df2\u52a0\u8f7d");
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> SPENDCMCommand.register((CommandDispatcher<class_2168>)dispatcher));
        if (!SPENDCM.config.enabled) {
            LOGGER.info("SPENDCM: \u6a21\u7ec4\u5df2\u7981\u7528");
            return;
        }
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::onServerStopping);
        ServerTickEvents.END_SERVER_TICK.register(this::onServerTick);
    }

    private void onServerStarted(MinecraftServer server) {
        SPENDCM.server = server;
        LOGGER.info("SPENDCM: \u670d\u52a1\u5668\u5df2\u542f\u52a8\uff0c\u5f00\u59cb\u76d1\u63a7\u73a9\u5bb6\u6d3b\u52a8");
    }

    private void onServerStopping(MinecraftServer server) {
        LOGGER.info("SPENDCM: \u670d\u52a1\u5668\u6b63\u5728\u5173\u95ed\uff0c\u6e05\u7406\u6570\u636e");
        playerLastActivity.clear();
    }

    private void onServerTick(MinecraftServer server) {
        if (!SPENDCM.config.enabled) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        for (class_3222 player : server.method_3760().method_14571()) {
            playerLastActivity.put(player.method_5667(), currentTime);
        }
        if (currentTime - lastCheckTime >= config.getCheckIntervalMillis()) {
            this.checkPlayerActivity();
            lastCheckTime = currentTime;
        }
    }

    private void checkPlayerActivity() {
        long currentTime = System.currentTimeMillis();
        boolean hasActivePlayers = false;
        for (class_3222 player : server.method_3760().method_14571()) {
            Long lastActivity = playerLastActivity.get(player.method_5667());
            if (lastActivity == null || currentTime - lastActivity > config.getCheckIntervalMillis()) continue;
            hasActivePlayers = true;
            break;
        }
        if (!hasActivePlayers && server.method_3760().method_14574() > 0) {
            LOGGER.info("SPENDCM: \u68c0\u6d4b\u5230{}\u5206\u949f\u5185\u65e0\u73a9\u5bb6\u6d3b\u52a8\uff0c\u6267\u884c\u6307\u4ee4", (Object)SPENDCM.config.checkIntervalMinutes);
            this.executeCommand();
        }
        playerLastActivity.keySet().removeIf(uuid -> server.method_3760().method_14602(uuid) == null);
    }

    private void executeCommand() {
        try {
            if (SPENDCM.config.logToConsole) {
                server.method_43496((class_2561)class_2561.method_43470((String)("[SPENDCM] \u68c0\u6d4b\u5230" + SPENDCM.config.checkIntervalMinutes + "\u5206\u949f\u5185\u65e0\u73a9\u5bb6\u6d3b\u52a8\uff0c\u6267\u884c\u9884\u8bbe\u6307\u4ee4")));
            }
            for (String command : SPENDCM.config.commands) {
                try {
                    server.method_3734().method_44252(server.method_3739(), command);
                    LOGGER.info("SPENDCM: \u6267\u884c\u6307\u4ee4: {}", (Object)command);
                }
                catch (Exception e) {
                    LOGGER.error("SPENDCM: \u6267\u884c\u6307\u4ee4\u65f6\u51fa\u9519: {}", (Object)command, (Object)e);
                }
            }
            LOGGER.info("SPENDCM: \u6240\u6709\u6307\u4ee4\u6267\u884c\u5b8c\u6210");
        }
        catch (Exception e) {
            LOGGER.error("SPENDCM: \u6267\u884c\u6307\u4ee4\u65f6\u51fa\u9519", (Throwable)e);
        }
    }

    public static long getPlayerLastActivity(UUID playerId) {
        return playerLastActivity.getOrDefault(playerId, 0L);
    }

    public static void updatePlayerActivity(UUID playerId) {
        playerLastActivity.put(playerId, System.currentTimeMillis());
    }

    public static ModConfig getConfig() {
        return config;
    }

    public static void reloadConfig() {
        config = ModConfig.load();
        LOGGER.info("SPENDCM: \u914d\u7f6e\u5df2\u91cd\u65b0\u52a0\u8f7d");
    }

    public static MinecraftServer getServer() {
        return server;
    }

    static {
        lastCheckTime = 0L;
    }
}

